#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	


	[TestFixture]
	public class BOL_TransfusionReport : BaseTest 
	{
		private BOL.TransfusionReport _testReport;
		private System.DateTime _currentDate = DateTime.Now;
		

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			this._testReport = new BOL.TransfusionReport();
		}

		[Test]
		public void Ctor_Dates_Pass()
		{
			DateTime startDate = DateTime.Now.Date.AddDays(-30);
			DateTime endDate = DateTime.Today.AddHours(23).AddMinutes(59).AddSeconds(59);
			BOL.TransfusionReport rpt = new BOL.TransfusionReport(startDate,endDate);
			//
			Assert.AreEqual(startDate,rpt.StartDate,"StartDate");
			Assert.AreEqual(endDate,rpt.EndDate,"EndDate");
			//
			Assert.AreEqual(true,rpt.IssuingPhysicianReport,"IssuingPhysicianReport");
			Assert.AreEqual(false,rpt.TreatingSpecialityReport,"TreatingSpecialityReport");
			Assert.AreEqual(false,rpt.IssuedToLocationReport,"IssuedToLocationReport");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Dates_Fail()
		{
		}

		[Test]
		public void Ctor_Empty_Pass()
		{
			BOL.TransfusionReport rpt = new BOL.TransfusionReport();
			//
			Assert.AreEqual(true,rpt.IssuingPhysicianReport,"IssuingPhysicianReport");
			Assert.AreEqual(false,rpt.TreatingSpecialityReport,"TreatingSpecialityReport");
			Assert.AreEqual(false,rpt.IssuedToLocationReport,"IssuedToLocationReport");

			Assert.AreEqual(false,rpt.IsScheduled,"IsScheduled");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Empty_Fail()
		{
		}

		[Test]
		public void IssuedToLocationReport_Pass()
		{
			bool val=true;

			this._testReport.IssuedToLocationReport=val;

			Assert.IsTrue(this._testReport.IssuedToLocationReport=val, "IssuedToLocationReport is true");				
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IssuedToLocationReport_Fail()
		{
		}

		[Test]
		public void TreatingSpecialityReport_Pass()
		{
			bool val=true;

			this._testReport.TreatingSpecialityReport=val;

			Assert.IsTrue(this._testReport.TreatingSpecialityReport=val, "TreatingSpecialityReport is true");				
		
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TreatingSpecialityReport_Fail()
		{
		}

		[Test]
		public void IssuingPhysicianReport_Pass()
		{
			bool val=true;

			this._testReport.IssuingPhysicianReport=val;

			Assert.IsTrue(this._testReport.IssuingPhysicianReport=val, "IssuingPhysicianReport is true");				
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IssuingPhysicianReport_Fail()
		{
		}

		[Test]
		public void FilterStatement_Pass()
		{
			string statement="(PhysicianName = 'VBECS')";

			this._testReport.FilterStatement=statement;

			Assert.IsTrue(this._testReport.FilterStatement.IndexOf("'VBECS'")>0, "FilterStatement contains 'VBECS'");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void FilterStatement_Fail()
		{
		}

		[Test]
		public void GenerateTransfusionReportSource_Pass()
		{
			new BOL.UnitTests.BOL_PatientTransfusion().GetIssuedAndTransfusedUnitsForPatient_Pass();
			this._testReport.StartDate=DateTime.Now.AddYears(-5);
			this._testReport.EndDate=DateTime.Now.AddYears(1);
			this._testReport.FilterStatement="|Blood Shack Baby|";
			this._testReport.IssuedToLocationReport=true;
			this._testReport.IssuingPhysicianReport=false;
			this._testReport.TreatingSpecialityReport=false;
			this._testReport.DivisionCode = Common.LogonUser.LogonUserDivisionCode;

			DataSet reportSource = this._testReport.GenerateTransfusionReportSource();
			
			Assert.IsTrue(reportSource.Tables[0].Rows.Count>=1, "GenerateTransfusionReportSource returns Data.");
		}

		[Test]
		public void GenerateTransfusionReportSource_Fail()
		{
			this._testReport.StartDate=DateTime.Now.AddYears(-1);
			this._testReport.EndDate=DateTime.Now;
			this._testReport.FilterStatement="(PhysicianName LIKE '%')";
			this._testReport.IssuingPhysicianReport=true;

			// This should cause the stored procedure to not return data.
			this._testReport.DivisionCode="INVALID";

			DataSet reportSource = this._testReport.GenerateTransfusionReportSource();
			Assert.IsTrue(reportSource.Tables[0].Rows.Count < 1, "GenerateTransfusionReportSource returns Data.");
		}
		
		[Test]
		public void AddPhysician_Pass()
		{
			this._testReport.AddPhysician("VBECS");
			this._testReport.IssuingPhysicianReport=true;

			Assert.IsTrue(this._testReport.GenerateFilterStatement().IndexOf("VBECS")>-1);
		}

		[Test]
		public void AddPhysician_Fail()
		{
			this._testReport.AddPhysician("    ");
			this._testReport.IssuingPhysicianReport=true;

			Assert.IsTrue(this._testReport.GenerateFilterStatement().IndexOf("    ")<0);
		}

		[Test]
		public void RemovePhysician_Pass()
		{
			this._testReport.AddPhysician("VBECS");
			this._testReport.AddPhysician("Greg Lohse");
			this._testReport.RemovePhysician("VBECS");
			this._testReport.IssuingPhysicianReport=true;

			Assert.IsTrue(this._testReport.GenerateFilterStatement().IndexOf("VBECS")<0);
		}

		[Test]
		public void RemovePhysician_Fail()
		{
			this._testReport.AddPhysician("VBECS");
			this._testReport.AddPhysician("Greg Lohse");
			this._testReport.RemovePhysician("SCEBV");
			this._testReport.IssuingPhysicianReport=true;

			Assert.IsTrue(this._testReport.GenerateFilterStatement().IndexOf("VBECS")>-1);
		
		}

		[Test]
		public void AddLocation_Pass()
		{
			this._testReport.IssuedToLocationReport=true;
			this._testReport.IssuingPhysicianReport=false; 
			this._testReport.TreatingSpecialityReport=false; 

			this._testReport.AddLocation("Hines");
			
			Assert.IsTrue(this._testReport.GenerateFilterStatement().IndexOf("Hines")>-1);
		}

		[Test]
		public void AddLocation_Fail()
		{			
			this._testReport.IssuedToLocationReport=true;
			this._testReport.AddLocation("   ");

			Assert.IsTrue(this._testReport.GenerateFilterStatement().IndexOf("   ")<0);
		}

		[Test]
		public void RemoveLocation_Pass()
		{
			this._testReport.IssuedToLocationReport=true;
			this._testReport.AddLocation("Hines");
			this._testReport.AddLocation("Chicago");
			this._testReport.RemoveLocation("Hines");

			Assert.IsTrue(this._testReport.GenerateFilterStatement().IndexOf("Hines")<0);
		}

		[Test]
		public void RemoveLocation_Fail()
		{			
			this._testReport.IssuedToLocationReport=true;
			this._testReport.IssuingPhysicianReport=false; 
			this._testReport.TreatingSpecialityReport=false; 

			this._testReport.AddLocation("Hines");
			this._testReport.AddLocation("Chicago");
			this._testReport.RemoveLocation("Senih");

			Assert.IsTrue(this._testReport.GenerateFilterStatement().IndexOf("Hines")>-1);
		}

		[Test]
		public void AddSpecialty_Pass()
		{	
			this._testReport.IssuedToLocationReport=false;
			this._testReport.IssuingPhysicianReport=false; 
			this._testReport.TreatingSpecialityReport=true; 

			this._testReport.AddSpecialty("SPECIALTY");

			Assert.IsTrue(this._testReport.GenerateFilterStatement().IndexOf("SPECIALTY")>-1);
		}

		[Test]
		public void AddSpecialty_Fail()
		{
			this._testReport.TreatingSpecialityReport=true;
			this._testReport.AddSpecialty("     ");

			Assert.IsTrue(this._testReport.GenerateFilterStatement().IndexOf("     ")<0);
		}

		[Test]
		public void RemoveSpecialty_Pass()
		{
			this._testReport.TreatingSpecialityReport=true;
			this._testReport.AddSpecialty("SPECIALTY 1");
			this._testReport.AddSpecialty("SPECIALTY 2");
			this._testReport.RemoveSpecialty("SPECIALTY 1");

			Assert.IsTrue(this._testReport.GenerateFilterStatement().IndexOf("SPECIALTY 1")<0);
		}

		[Test]
		public void RemoveSpecialty_Fail()
		{
			this._testReport.IssuedToLocationReport=false;
			this._testReport.IssuingPhysicianReport=false; 
			this._testReport.TreatingSpecialityReport=true; 

			this._testReport.AddSpecialty("SPECIALTY 1");
			this._testReport.AddSpecialty("SPECIALTY 2");
			this._testReport.RemoveSpecialty("SPECIALTY");

			Assert.IsTrue(this._testReport.GenerateFilterStatement().IndexOf("SPECIALTY 1")>-1);
		}
		
		[Test]
		public void GenerateFilterStatement_Pass()
		{
			this._testReport.IssuedToLocationReport=true;
			this._testReport.IssuingPhysicianReport=true; 
			this._testReport.TreatingSpecialityReport=true; 

			this._testReport.AddLocation("LOCATION 1");
			this._testReport.AddPhysician("PHYSICIAN 2");
			this._testReport.AddSpecialty("SPECIALTY 3");
			
			Assert.IsTrue(this._testReport.GenerateFilterStatement().IndexOf("LOCATION 1")>-1,"LOCATION");
			Assert.IsTrue(this._testReport.GenerateFilterStatement().IndexOf("PHYSICIAN 2")>-1,"PHYSICIAN");
			Assert.IsTrue(this._testReport.GenerateFilterStatement().IndexOf("SPECIALTY 3")>-1,"SPECIALTY");
		}

		[Test]
		public void GenerateFilterStatement_Fail()
		{
			// By setting the following attributes all to false
			// will cause the generatefilterstatement command
			// to not work properly.
			this._testReport.TreatingSpecialityReport=false;
			this._testReport.IssuingPhysicianReport=false;
			this._testReport.IssuedToLocationReport=false;

			this._testReport.AddLocation("LOCATION 1");
			this._testReport.AddPhysician("PHYSICIAN 2");
			this._testReport.AddSpecialty("SPECIALTY 3");
			
			Assert.AreEqual(-1,this._testReport.GenerateFilterStatement().IndexOf("LOCATION 1"),"LOCATION");
			Assert.AreEqual(-1,this._testReport.GenerateFilterStatement().IndexOf("PHYSICIAN 2"),"PHYSICIAN");
			Assert.AreEqual(-1,this._testReport.GenerateFilterStatement().IndexOf("SPECIALTY 3"),"SPECIALTY");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Pass()
		{
			//Sends report to printer
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Fail()
		{
			//Sends report to printer
		}
	}
}
#endif
